#include "stdafx.h"
#include "ConfigLoader.h"

CConfigLoader::CConfigLoader(CConfig *Config, RichTextBox *txtConsole)
{
	this->Config = Config;
	this->txtConsole = txtConsole;
}

bool CConfigLoader::LoadConfigFile(String *sFile)
{
	if(!File::Exists(sFile))
		return false;

	txtConsole->SelectionColor = Color::Green;
	txtConsole->AppendText(String::Concat(S"Loading ", sFile, S"..."));

	StreamReader *ConfigFile;

	try
	{
		ConfigFile = new StreamReader(sFile, System::Text::Encoding::ASCII);
	}
	catch(Exception *e)
	{
		txtConsole->SelectionColor = Color::Red;
		txtConsole->AppendText(String::Concat(S"Error loading ", sFile, S": ", e->Message, S"\n"));
		return false;
	}

	try
	{
		String *sLine, *sArg, *sVal;

		while((sLine = ConfigFile->ReadLine()) != NULL)
		{
			if(!ProcessLine(sLine, &sArg, &sVal))
				continue;

			try
			{
				// General
				if(sArg->Equals("general.recentmapcount"))
				{
					Config->iRecentMAPCount = Convert::ToInt32(sVal);
				}

				// Engine
				else if(sArg->Equals("engine.colorbits"))
				{
					Config->bColorBits = Convert::ToByte(sVal);
				}
				else if(sArg->Equals("engine.depthbits"))
				{
					Config->bDepthBits = Convert::ToByte(sVal);
				}
				else if(sArg->Equals("engine.backcolor.r"))
				{
					Config->cBackColor.R = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.backcolor.g"))
				{
					Config->cBackColor.G = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.backcolor.b"))
				{
					Config->cBackColor.B = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.backcolor.a"))
				{
					Config->cBackColor.A = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.forecolor.r"))
				{
					Config->cForeColor.R = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.forecolor.g"))
				{
					Config->cForeColor.G = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.forecolor.b"))
				{
					Config->cForeColor.B = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.forecolor.a"))
				{
					Config->cForeColor.A = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.highlightcolor.r"))
				{
					Config->cHighlightColor.R = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.highlightcolor.g"))
				{
					Config->cHighlightColor.G = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.highlightcolor.b"))
				{
					Config->cHighlightColor.B = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.highlightcolor.a"))
				{
					Config->cHighlightColor.A = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.outlinecolor.r"))
				{
					Config->cOutlineColor.R = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.outlinecolor.g"))
				{
					Config->cOutlineColor.G = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.outlinecolor.b"))
				{
					Config->cOutlineColor.B = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("engine.outlinecolor.a"))
				{
					Config->cOutlineColor.A = Convert::ToSingle(sVal);
				}

				// Camera
				else if(sArg->Equals("camera.invertcamera"))
				{
					Config->bInvertCamera = Convert::ToBoolean(sVal);
				}
				else if(sArg->Equals("camera.cameraspeed"))
				{
					Config->fCameraSpeed = Convert::ToSingle(sVal);
				}
				else if(sArg->Equals("camera.cameraboost"))
				{
					Config->fCameraBoost = Convert::ToSingle(sVal);
				}

				// Renderer
				else if(sArg->Equals("renderer.drawspecialtextures"))
				{
					Config->bDrawSpecialTextures = Convert::ToBoolean(sVal);
				}
				else if(sArg->Equals("renderer.drawselection"))
				{
					Config->bDrawSelection = Convert::ToBoolean(sVal);
				}
				else if(sArg->Equals("renderer.drawpointfile"))
				{
					Config->bDrawPointFile = Convert::ToBoolean(sVal);
				}
				else if(sArg->Equals("renderer.lightscene"))
				{
					Config->bLightScene = Convert::ToBoolean(sVal);
				}
				else if(sArg->Equals("renderer.outlinescene"))
				{
					Config->bOutlineScene = Convert::ToBoolean(sVal);
				}
				else if(sArg->Equals("renderer.rendermode"))
				{
					Config->eRenderMode = *static_cast<__box RenderMode::RenderMode*>(Enum::Parse(__typeof(RenderMode::RenderMode), sVal, false));
				}
				else if(sArg->Equals("renderer.texturefilter"))
				{
					Config->eTextureFilter = *static_cast<__box TextureFilter::TextureFilter*>(Enum::Parse(__typeof(TextureFilter::TextureFilter), sVal, false));
				}

				//Textures
				else if(sArg->Equals("textures.halflifepath"))
				{
					Config->sHalfLifePath = sVal;
				}
			}
			catch(Exception *e)
			{
				continue;
			}
		}
	}
	catch(Exception *e)
	{
		txtConsole->SelectionColor = Color::Red;
		txtConsole->AppendText(String::Concat(S"Error loading ", sFile, S": ", e->Message, S"\n"));
		ConfigFile->Close();
		return false;
	}

	ConfigFile->Close();

	txtConsole->SelectionColor = Color::Green;
	txtConsole->AppendText("done.\n");

	return true;
}

bool CConfigLoader::ProcessLine(String *sLine, String **sArg, String **sVal)
{
	*sArg = NULL;
	*sVal = NULL;

	sLine = sLine->Trim();

	if(sLine->IndexOf("//") != -1)
	{
		sLine = sLine->Remove(sLine->IndexOf("//"), sLine->Length)->Trim();

		if(sLine->Length == 0)
			return false;
	}

	if(sLine->IndexOf("=") == -1)
		return false;

	*sArg = sLine->Substring(0, sLine->IndexOf("="))->Trim()->ToLower();
	*sVal = sLine->Substring(sLine->IndexOf("=") + 1)->Trim();

	return true;
}